/*
 * Decompiled with CFR 0.152.
 */
package net.nooj4nlp.engine;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Stack;
import javax.swing.JOptionPane;
import net.nooj4nlp.engine.DState;
import net.nooj4nlp.engine.Dic;
import net.nooj4nlp.engine.Dictionary;
import net.nooj4nlp.engine.Engine;
import net.nooj4nlp.engine.Gram;
import net.nooj4nlp.engine.Language;
import net.nooj4nlp.engine.RefObject;
import net.nooj4nlp.engine.UnsignedByte;
import net.nooj4nlp.engine.helper.ParameterCheck;
import net.nooj4nlp.gui.main.Launcher;

public class FSDic
implements Serializable {
    public static int etatsave = 1;
    private static final long serialVersionUID = -4795046378802556971L;
    transient ArrayList<DState> states;
    private transient HashMap<String, Integer> he = null;
    private transient ArrayList<String> ae = null;
    private transient HashMap<String, Integer> hi;
    private transient HashMap<Character, Integer> hc;
    private transient int charnb;
    private transient int[] stateaddress;
    transient Language Lan;
    private transient int Protection;
    private transient int alphabetlog;
    private transient int infolog;
    private transient int buflog;
    private transient int buflogc;
    private transient char[] alphabet;
    transient String[] infos;
    private transient String[] infobitstable;
    transient UnsignedByte[] buffer;
    transient UnsignedByte[] bufferc;
    transient UnsignedByte[] bufferl;
    transient UnsignedByte[] buffercl;
    transient HashMap<String, Gram> paradigms;
    private HashMap<String, Object> Params;
    private transient ArrayList<Integer> FreeStates = null;
    private transient int NbOfInfosForEq;
    private transient int counter;
    private transient boolean verbose = false;
    transient String Comments = null;

    FSDic(String isoname) {
        ParameterCheck.mandatory("isoname", isoname);
        this.Lan = new Language(isoname);
        if (this.Lan != null) {
            this.states = new ArrayList();
            this.createState();
            this.infos = null;
            this.he = null;
            this.hc = new HashMap();
            this.charnb = 1;
            this.hi = new HashMap();
        }
    }

    private ArrayList<String> unCompactInfo(String information) {
        ParameterCheck.mandatoryString("information", information);
        ArrayList<String> info = new ArrayList<String>();
        if (information.length() > 8 && information.substring(0, 8).equals("4 bytes:")) {
            int i = 8;
            while (i < information.length()) {
                String inf = "";
                while (i < information.length()) {
                    char h = information.charAt(i);
                    char l = information.charAt(i + 1);
                    if (h == '\u0000' && l == '\u0000') break;
                    int infnb = h * 65536 + l;
                    inf = inf + this.infobitstable[infnb];
                    i += 2;
                }
                info.add(inf);
                if (i >= information.length()) continue;
                i += 2;
            }
        } else {
            int i = 0;
            while (i < information.length()) {
                String inf = "";
                while (i < information.length() && information.charAt(i) != '\u0000') {
                    char infonb = information.charAt(i);
                    inf = infonb < this.infobitstable.length ? inf + this.infobitstable[infonb] : inf + "+ERROR";
                    ++i;
                }
                info.add(inf);
                if (i >= information.length()) continue;
                ++i;
            }
        }
        return info;
    }

    private String compactInfo(String informationlemma, String informationflex, FSDic dics) {
        int i;
        ArrayList<Integer> comp = new ArrayList<Integer>();
        String[] fields2 = new String[]{informationlemma, informationflex};
        for (int i2 = 0; i2 < fields2.length; ++i2) {
            String fd2 = i2 == 0 ? (comp.size() > 0 ? "," + fields2[i2] : fields2[i2]) : "+" + fields2[i2];
            if (!dics.hi.containsKey(fd2)) {
                int encoder = dics.hi.size() + 1;
                dics.hi.put(fd2, encoder);
            }
            comp.add(dics.hi.get(fd2));
        }
        boolean needfourbytes = false;
        for (int i3 = 0; i3 < comp.size(); ++i3) {
            int c = (Integer)comp.get(i3);
            if (c < 65535) continue;
            needfourbytes = true;
            break;
        }
        StringBuilder result = new StringBuilder();
        if (!needfourbytes) {
            for (i = 0; i < comp.size(); ++i) {
                result.append(comp.get(i));
            }
        } else {
            result.append("4 bytes:");
            for (i = 0; i < comp.size(); ++i) {
                int c = (Integer)comp.get(i);
                char h = (char)(c / 65536);
                char l = (char)(c % 65536);
                result.append(h);
                result.append(l);
            }
        }
        return result.toString();
    }

    private String compactInfo(String lemma, String informationlemma, String informationflex, FSDic dics) {
        int i;
        int encoder;
        ArrayList<Integer> comp = new ArrayList<Integer>();
        if (!dics.hi.containsKey(lemma)) {
            int encoder2 = dics.hi.size() + 1;
            dics.hi.put(lemma, encoder2);
        }
        comp.add(dics.hi.get(lemma));
        String info0 = "," + informationlemma;
        if (!dics.hi.containsKey(info0)) {
            encoder = dics.hi.size() + 1;
            dics.hi.put(info0, encoder);
        }
        comp.add(dics.hi.get(info0));
        if (!dics.hi.containsKey(informationflex)) {
            encoder = dics.hi.size() + 1;
            dics.hi.put(informationflex, encoder);
        }
        comp.add(dics.hi.get(informationflex));
        boolean needfourbytes = false;
        for (int i2 = 0; i2 < comp.size(); ++i2) {
            int c = (Integer)comp.get(i2);
            if (c < 65535) continue;
            needfourbytes = true;
            break;
        }
        StringBuilder result = new StringBuilder();
        if (!needfourbytes) {
            for (i = 0; i < comp.size(); ++i) {
                int c = (Integer)comp.get(i);
                result.append((char)c);
            }
        } else {
            result.append("4 bytes:");
            for (i = 0; i < comp.size(); ++i) {
                int c = (Integer)comp.get(i);
                char h = (char)(c / 65536);
                char l = (char)(c % 65536);
                result.append(h);
                result.append(l);
            }
        }
        return result.toString();
    }

    private void deleteState(int index) {
        this.states.set(index, null);
        this.ae.set(index, null);
        if (this.FreeStates == null) {
            this.FreeStates = new ArrayList();
        }
        this.FreeStates.add(index);
    }

    private int createState(int iparent) {
        int c;
        DState nstate = new DState(iparent);
        int index = -1;
        if (this.FreeStates != null && (c = this.FreeStates.size()) > 0) {
            index = this.FreeStates.get(c - 1);
            this.FreeStates.remove(c - 1);
        }
        if (index != -1) {
            this.states.set(index, nstate);
            this.ae.set(index, null);
        } else {
            this.states.add(nstate);
            index = this.states.size() - 1;
            if (this.ae == null) {
                this.ae = new ArrayList();
            }
            this.ae.add(null);
        }
        return index;
    }

    private int createState() {
        int c;
        DState nstate = new DState();
        int index = -1;
        if (this.FreeStates != null && (c = this.FreeStates.size()) > 0) {
            index = this.FreeStates.get(c - 1);
            this.FreeStates.remove(c - 1);
        }
        if (index != -1) {
            this.states.set(index, nstate);
            this.ae.set(index, null);
        } else {
            this.states.add(nstate);
            index = this.states.size() - 1;
            if (this.ae == null) {
                this.ae = new ArrayList();
            }
            this.ae.add(null);
        }
        return index;
    }

    private void addParent(int istate, int iparent) {
        DState state = this.states.get(istate);
        for (int i = 0; i < state.parents.length; ++i) {
            if (state.parents[i] != iparent) continue;
            return;
        }
        int[] nparents = new int[state.parents.length + 1];
        for (int i = 0; i < state.parents.length; ++i) {
            nparents[i] = state.parents[i];
        }
        nparents[nparents.length - 1] = iparent;
        state.parents = nparents;
    }

    private void removeParent(int istate, int iparent) {
        DState state = this.states.get(istate);
        int index = -1;
        for (int i = 0; i < state.parents.length; ++i) {
            if (state.parents[i] != iparent) continue;
            index = i;
            break;
        }
        if (index != -1) {
            int inew;
            int[] nparents = new int[state.parents.length - 1];
            for (inew = 0; inew < index; ++inew) {
                nparents[inew] = state.parents[inew];
            }
            for (inew = index + 1; inew < state.parents.length; ++inew) {
                nparents[inew - 1] = state.parents[inew];
            }
            state.parents = nparents;
        }
    }

    void cleanupInflectionCommands() {
        if (this.paradigms != null) {
            for (Gram grm : this.paradigms.values()) {
                grm.InflectionsCommands = null;
            }
        }
    }

    private int setEqName(int istate) {
        int eqstate;
        DState cstate = this.states.get(istate);
        if (cstate.canonical) {
            return istate;
        }
        StringBuilder eqname = new StringBuilder();
        if (cstate.infonb != 0) {
            if (this.NbOfInfosForEq < 65535) {
                char stateinfonb = (char)cstate.infonb;
                eqname.append(stateinfonb);
            } else {
                eqname.append(cstate.infonb);
            }
        }
        if (cstate.chars != null) {
            char cnboftrans = (char)cstate.chars.length;
            eqname.append(cnboftrans);
            if (cstate.chars.length > 1) {
                cstate.sortCharsDests();
            }
            for (int it = 0; it < cstate.chars.length; ++it) {
                int character = cstate.chars[it];
                eqname.append((char)character);
                int dest = cstate.dests[it];
                int eqdest = this.setEqName(dest);
                eqname.append(eqdest);
            }
        }
        String eqn = eqname.toString();
        if (this.he != null && this.he.containsKey(eqn)) {
            eqstate = this.he.get(eqn);
            if (eqstate != istate) {
                String se;
                if (this.verbose) {
                    this.checkConsistency();
                }
                for (int iparent : cstate.parents) {
                    DState pstate = this.states.get(iparent);
                    pstate.replaceDest(istate, eqstate);
                    this.addParent(eqstate, iparent);
                }
                if (cstate.dests != null) {
                    for (int it = 0; it < cstate.dests.length; ++it) {
                        int ichildstate = cstate.dests[it];
                        this.removeParent(ichildstate, istate);
                        this.addParent(ichildstate, eqstate);
                    }
                }
                if ((se = this.ae.get(istate)) != null) {
                    this.he.remove(se);
                }
                this.deleteState(istate);
                if (this.verbose) {
                    this.checkConsistency();
                }
            }
        } else {
            if (this.he == null) {
                this.he = new HashMap();
            }
            this.he.put(eqn, istate);
            this.ae.set(istate, eqn);
            eqstate = istate;
            cstate.canonical = true;
        }
        return eqstate;
    }

    private void invalidateAllStates() {
        this.he = new HashMap();
        this.ae = new ArrayList();
        for (int istate = 0; istate < this.states.size(); ++istate) {
            this.ae.add(null);
            DState cstate = this.states.get(istate);
            cstate.canonical = false;
        }
    }

    private void invalidateStates(int istate) {
        DState s = this.states.get(istate);
        if (s.canonical) {
            s.canonical = false;
            String se = this.ae.get(istate);
            if (se != null) {
                this.he.remove(se);
            }
            this.ae.set(istate, null);
        }
        if (s.parents != null) {
            for (int iparent : s.parents) {
                this.invalidateStates(iparent);
            }
        }
    }

    void minimize(int nbofinfos) {
        this.NbOfInfosForEq = nbofinfos;
        this.setEqName(0);
    }

    private void cloneState(int istate) {
        DState cstate = this.states.get(istate);
        for (int ip = 0; ip < cstate.parents.length; ++ip) {
            int iparent = cstate.parents[ip];
            DState pstate = this.states.get(iparent);
            if (pstate.dests == null) continue;
            for (int it = 0; it < pstate.dests.length; ++it) {
                int dest = pstate.dests[it];
                if (dest != istate) continue;
                int instate = this.createState(iparent);
                DState nstate = this.states.get(instate);
                nstate.infonb = cstate.infonb;
                if (cstate.chars != null) {
                    nstate.chars = (char[])cstate.chars.clone();
                    nstate.dests = (int[])cstate.dests.clone();
                    for (int jt = 0; jt < nstate.dests.length; ++jt) {
                        int id = nstate.dests[jt];
                        this.addParent(id, instate);
                        this.removeParent(id, istate);
                    }
                }
                pstate.dests[it] = instate;
                this.invalidateStates(iparent);
            }
        }
        String se = this.ae.get(istate);
        if (se != null) {
            this.he.remove(se);
        }
        this.deleteState(istate);
    }

    private boolean cloneTrace(ArrayList<Integer> statestrace) {
        ParameterCheck.mandatory("statestrace", statestrace);
        boolean cloned = false;
        for (int ist : statestrace) {
            DState cstate = this.states.get(ist);
            if (cstate.parents == null || cstate.parents.length <= 1) continue;
            this.cloneState(ist);
            cloned = true;
            break;
        }
        return cloned;
    }

    private int countStates() {
        if (this.FreeStates == null) {
            return this.states.size();
        }
        return this.states.size() - this.FreeStates.size();
    }

    private void checkConsistency() {
        for (int istate = 0; istate < this.states.size(); ++istate) {
            DState state = this.states.get(istate);
            if (state == null) continue;
            for (int iparent : state.parents) {
                DState pstate = this.states.get(iparent);
                if (pstate == null) {
                    return;
                }
                for (int ic : pstate.dests) {
                    if (ic == istate) break;
                }
            }
            if (state.dests == null) continue;
            for (int idest : state.dests) {
                DState child = this.states.get(idest);
                for (int ip : child.parents) {
                    if (ip == istate) break;
                }
            }
        }
    }

    void addLexLineToDic(String entry, String lemma, String infolemma, String infoflex, FSDic dics0, FSDic dics, HashMap<String, Integer> hDicInfos, ArrayList<String> aDicInfos, boolean isacompound) {
        DState state;
        int istate;
        ParameterCheck.mandatoryString("entry", entry);
        ParameterCheck.mandatory("dics", dics);
        ParameterCheck.mandatory("hDicInfos", hDicInfos);
        ParameterCheck.mandatory("aDicInfos", aDicInfos);
        ++this.counter;
        if (this.counter % 1000000 == 0) {
            Dic.writeLog(" > " + this.counter + " forms; " + this.countStates() + " states.");
        }
        if (this.he == null) {
            this.invalidateAllStates();
        }
        String newlemma = isacompound || this.Lan.asianTokenizer ? Dic.compressCompoundLemma(entry, lemma) : Dic.compressSimpleLemma(entry, lemma);
        while (true) {
            ArrayList<Integer> statestrace = new ArrayList<Integer>();
            boolean breakedFor = false;
            istate = 0;
            for (int i = 0; i < entry.length(); ++i) {
                int[] newdests;
                char[] newchars;
                statestrace.add(istate);
                char c = entry.charAt(i);
                if (!dics.hc.containsKey(Character.valueOf(c))) {
                    dics.hc.put(Character.valueOf(c), dics.charnb++);
                }
                state = this.states.get(istate);
                int index = -1;
                if (state.chars != null) {
                    for (int it = 0; it < state.chars.length; ++it) {
                        char character = state.chars[it];
                        if (character != c) continue;
                        index = it;
                        break;
                    }
                }
                if (index != -1) {
                    istate = state.dests[index];
                    continue;
                }
                if (this.cloneTrace(statestrace)) {
                    breakedFor = true;
                    break;
                }
                int dest = this.createState(istate);
                if (state.chars == null) {
                    newchars = new char[]{c};
                    newdests = new int[]{dest};
                } else {
                    newchars = Arrays.copyOf(state.chars, state.chars.length + 1);
                    newchars[state.chars.length] = c;
                    newdests = Arrays.copyOf(state.dests, state.dests.length + 1);
                    newdests[state.dests.length] = dest;
                }
                state.chars = newchars;
                state.dests = newdests;
                istate = dest;
            }
            if (breakedFor) continue;
            state = this.states.get(istate);
            statestrace.add(istate);
            if (!this.cloneTrace(statestrace)) break;
        }
        String compactedinfo = newlemma == null ? this.compactInfo(infolemma, infoflex, dics0) : this.compactInfo(newlemma, infolemma, infoflex, dics0);
        String infostring = null;
        if (state.infonb == 0) {
            infostring = compactedinfo;
        } else if (!compactedinfo.equals(infostring)) {
            int iinfo;
            infostring = aDicInfos.get(state.infonb);
            if (compactedinfo.length() >= 8 && compactedinfo.substring(0, 8).equals("4 bytes:")) {
                if (infostring.length() >= 8 && infostring.substring(0, 8).equals("4 bytes:")) {
                    infostring = compactedinfo + "\u0000\u0000" + infostring.substring(8);
                } else {
                    String tmp = compactedinfo + "\u0000\u0000";
                    for (iinfo = 0; iinfo < infostring.length(); ++iinfo) {
                        tmp = tmp + '\u0000';
                        tmp = tmp + infostring.charAt(iinfo);
                    }
                    infostring = tmp;
                }
            } else if (infostring.length() >= 8 && infostring.substring(0, 8).equals("4 bytes:")) {
                String tmp = infostring + "\u0000\u0000";
                for (iinfo = 0; iinfo < compactedinfo.length(); ++iinfo) {
                    tmp = tmp + '\u0000';
                    tmp = tmp + compactedinfo.charAt(iinfo);
                }
                infostring = tmp;
            } else {
                infostring = infostring + "\u0000" + compactedinfo;
            }
        }
        if (hDicInfos.containsKey(infostring)) {
            state.infonb = hDicInfos.get(infostring);
        } else {
            aDicInfos.add(infostring);
            state.infonb = aDicInfos.size() - 1;
            hDicInfos.put(infostring, state.infonb);
        }
        this.invalidateStates(istate);
        if (this.counter % 1000000 == 0) {
            this.minimize(aDicInfos.size());
        }
    }

    private static void writeToBuf(int info, UnsignedByte[] buf, int bufindex, int sizelog) {
        ParameterCheck.mandatory("buf", buf);
        switch (sizelog) {
            case 1: {
                buf[bufindex].setB((byte)((long)info % 256L));
                break;
            }
            case 2: {
                buf[bufindex].setB((byte)((long)info / 256L % 256L));
                buf[bufindex + 1].setB((byte)((long)info % 256L));
                break;
            }
            case 3: {
                buf[bufindex].setB((byte)((long)info / 256L / 256L % 256L));
                buf[bufindex + 1].setB((byte)((long)info / 256L % 256L));
                buf[bufindex + 2].setB((byte)((long)info % 256L));
                break;
            }
            case 4: {
                buf[bufindex].setB((byte)((long)info / 256L / 256L / 256L % 256L));
                buf[bufindex + 1].setB((byte)((long)info / 256L / 256L % 256L));
                buf[bufindex + 2].setB((byte)((long)info / 256L % 256L));
                buf[bufindex + 3].setB((byte)((long)info % 256L));
            }
        }
    }

    private static int readFromBuf(UnsignedByte[] buf, int ib, int sizelog) {
        ParameterCheck.mandatory("buf", buf);
        int info = 0;
        switch (sizelog) {
            case 1: {
                info = buf[ib].getInt();
                break;
            }
            case 2: {
                info = 256 * buf[ib].getInt() + buf[ib + 1].getInt();
                break;
            }
            case 3: {
                info = 65536 * buf[ib].getInt() + 256 * buf[ib + 1].getInt() + buf[ib + 2].getInt();
                break;
            }
            case 4: {
                info = 0x1000000 * buf[ib].getInt() + 65536 * buf[ib + 1].getInt() + 256 * buf[ib + 2].getInt() + buf[ib + 3].getInt();
            }
        }
        return info;
    }

    private final void stateToBinary(DState state, UnsignedByte[] buf, int bufindex, int alphabetlog, int infolog, int buflog, FSDic dics) {
        ParameterCheck.mandatory("state", state);
        ParameterCheck.mandatory("dics", dics);
        int ib = bufindex;
        FSDic.writeToBuf(state.infonb, buf, ib, infolog);
        ib += infolog;
        if (state.chars == null) {
            FSDic.writeToBuf(0, buf, ib, alphabetlog);
            ib += alphabetlog;
            return;
        }
        FSDic.writeToBuf(state.chars.length, buf, ib, alphabetlog);
        ib += alphabetlog;
        for (int it = 0; it < state.dests.length; ++it) {
            char character = state.chars[it];
            int charindex = dics.hc.get(Character.valueOf(character));
            FSDic.writeToBuf(charindex, buf, ib, alphabetlog);
            int idest = state.dests[it];
            int destaddr = this.stateaddress[idest];
            FSDic.writeToBuf(destaddr, buf, ib += alphabetlog, buflog);
            ib += buflog;
        }
        state.chars = null;
        state.dests = null;
    }

    private int guessNeededSizeLog(int try_alphabetlog, int try_infolog) {
        int size;
        DState state;
        int istate;
        int try_buflog = 2;
        int address = 0;
        boolean notenough = false;
        for (istate = 0; istate < this.states.size(); ++istate) {
            state = this.states.get(istate);
            if (state == null || (address += (size = state.chars == null ? try_infolog + try_alphabetlog + 0 : try_infolog + try_alphabetlog + state.chars.length * try_alphabetlog + state.dests.length * try_buflog)) < 65536) continue;
            notenough = true;
            break;
        }
        if (notenough) {
            try_buflog = 3;
            address = 0;
            notenough = false;
            for (istate = 0; istate < this.states.size(); ++istate) {
                state = this.states.get(istate);
                if (state == null || (address += (size = state.chars == null ? try_infolog + try_alphabetlog + 0 : try_infolog + try_alphabetlog + state.chars.length * try_alphabetlog + state.dests.length * try_buflog)) < 0x1000000) continue;
                notenough = true;
                break;
            }
            if (notenough) {
                try_buflog = 4;
                address = 0;
                for (istate = 0; istate < this.states.size(); ++istate) {
                    state = this.states.get(istate);
                    if (state == null) continue;
                    size = state.chars == null ? try_infolog + try_alphabetlog + 0 : try_infolog + try_alphabetlog + state.chars.length * try_alphabetlog + state.dests.length * try_buflog;
                    address += size;
                }
            }
        }
        return try_buflog;
    }

    private int computeNeededSize(int d_alphabetlog, int d_infolog, int d_buflog) {
        this.stateaddress = new int[this.states.size()];
        int address = 0;
        for (int istate = 0; istate < this.states.size(); ++istate) {
            DState state = this.states.get(istate);
            if (state == null) continue;
            this.stateaddress[istate] = address;
            int size = state.chars == null ? d_infolog + d_alphabetlog + 0 : d_infolog + d_alphabetlog + state.chars.length * d_alphabetlog + state.dests.length * d_buflog;
            address += size;
        }
        return address;
    }

    private static int getLargest(int a, int b, int c, int d) {
        int res = a;
        if (b > res) {
            res = b;
        }
        if (c > res) {
            res = c;
        }
        if (d > res) {
            res = d;
        }
        return res;
    }

    public static void computeAllLogs(FSDic dics, FSDic dicc, FSDic dicsLemma, FSDic diccLemma) {
        ParameterCheck.mandatory("dics", dics);
        ParameterCheck.mandatory("dicc", dicc);
        ParameterCheck.mandatory("dicsLemma", dicsLemma);
        ParameterCheck.mandatory("diccLemma", diccLemma);
        dics.alphabetlog = dics.charnb <= 255 ? 1 : (dics.charnb <= 65535 ? 2 : 4);
        dics.infolog = dics.infos.length <= 255 ? 1 : (dics.infos.length <= 65535 ? 2 : 4);
        int buflog_dics = dics.guessNeededSizeLog(dics.alphabetlog, dics.infolog);
        int buflog_dicc = dicc.guessNeededSizeLog(dics.alphabetlog, dics.infolog);
        int buflog_dicsLemma = dicsLemma.guessNeededSizeLog(dics.alphabetlog, dics.infolog);
        int buflog_diccLemma = diccLemma.guessNeededSizeLog(dics.alphabetlog, dics.infolog);
        dics.buflog = FSDic.getLargest(buflog_dics, buflog_dicc, buflog_dicsLemma, buflog_diccLemma);
    }

    public void toBinaryAlphabetInfobitstable() {
        this.alphabet = new char[this.charnb];
        for (Character cc : this.hc.keySet()) {
            this.alphabet[this.hc.get((Object)cc).intValue()] = cc.charValue();
        }
        this.hc = null;
        this.infobitstable = new String[this.hi.size() + 1];
        for (String s : this.hi.keySet()) {
            int c = this.hi.get(s);
            this.infobitstable[c] = s;
        }
    }

    public UnsignedByte[] toBinary(FSDic dics) {
        ParameterCheck.mandatory("dics", dics);
        int address = this.computeNeededSize(dics.alphabetlog, dics.infolog, dics.buflog);
        UnsignedByte[] buf = new UnsignedByte[address];
        try {
            for (int i = 0; i < address; ++i) {
                buf[i] = new UnsignedByte();
            }
            int iad = 0;
            for (int istate = 0; istate < this.states.size(); ++istate) {
                DState state = this.states.get(istate);
                if (state == null) continue;
                int size = state.chars == null ? dics.infolog + dics.alphabetlog + 0 : dics.infolog + dics.alphabetlog + state.chars.length * dics.alphabetlog + state.dests.length * dics.buflog;
                this.stateToBinary(state, buf, iad, dics.alphabetlog, dics.infolog, dics.buflog, dics);
                iad += size;
            }
            this.stateaddress = null;
            return buf;
        }
        catch (OutOfMemoryError E) {
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Compilation Stopped.. Insufficient Memory!!!", "NooJ", 0);
            return null;
        }
    }

    static FSDic[] load(String fullname, Engine engine, RefObject<String> errmessage) throws IOException, ClassNotFoundException {
        ParameterCheck.mandatoryString("fullname", fullname);
        ParameterCheck.mandatory("engine", engine);
        ParameterCheck.mandatory("errmessage", errmessage);
        FSDic dic = null;
        errmessage.argvalue = null;
        try {
            FileInputStream fs = new FileInputStream(fullname);
            ObjectInputStream serializer = new ObjectInputStream(fs);
            dic = (FSDic)serializer.readObject();
            if (serializer != null) {
                serializer.close();
            }
            if (fs != null) {
                fs.close();
            }
        }
        catch (RuntimeException ex) {
            errmessage.argvalue = "Error: cannot load binary dictionary " + fullname + "\r" + ex.getMessage();
            Dic.writeLog((String)errmessage.argvalue);
            return null;
        }
        String lname = (String)dic.Params.get("LanguageName");
        dic.Lan = engine.Lan.isoName.equals(lname) ? engine.Lan : new Language(lname);
        if (dic.Lan == null) {
            return null;
        }
        dic.Protection = (Integer)dic.Params.get("Protection");
        if (dic.Params.containsKey("Paradigms")) {
            dic.paradigms = (HashMap)dic.Params.get("Paradigms");
        }
        if (dic.Params.get("Infos").getClass().getName().equals("ArrayList")) {
            ArrayList infos = (ArrayList)dic.Params.get("Infos");
            dic.infos = infos.toArray(new String[infos.size()]);
        } else {
            dic.infos = (String[])dic.Params.get("Infos");
        }
        dic.infobitstable = (String[])dic.Params.get("Infobitstable");
        dic.infolog = (Integer)dic.Params.get("Infolog");
        dic.alphabet = (char[])dic.Params.get("Alphabet");
        dic.alphabetlog = (Integer)dic.Params.get("Alphabetlog");
        dic.buffer = (UnsignedByte[])dic.Params.get("Buffer");
        dic.bufferc = (UnsignedByte[])dic.Params.get("Bufferc");
        if (dic.Params.containsKey("BufferL")) {
            dic.bufferl = (UnsignedByte[])dic.Params.get("BufferL");
        }
        if (dic.Params.containsKey("BuffercL")) {
            dic.buffercl = (UnsignedByte[])dic.Params.get("BuffercL");
        }
        if (dic.Params.containsKey("Properties")) {
            // empty if block
        }
        if (dic.Params.containsKey("Buflog")) {
            dic.buflogc = dic.buflog = ((Integer)dic.Params.get("Buflog")).intValue();
        } else if (!dic.Params.containsKey("version")) {
            dic.buflogc = 3;
            dic.buflog = 3;
        } else {
            dic.buflog = dic.buffer.length < 65536 ? 2 : (dic.buffer.length < 0x1000000 ? 3 : 4);
            if (dic.bufferc != null) {
                dic.buflogc = dic.bufferc.length < 65536 ? 2 : (dic.bufferc.length < 0x1000000 ? 3 : 4);
            }
        }
        FSDic[] dics = new FSDic[]{dic};
        return dics;
    }

    final void save(String fname) throws IOException {
        ParameterCheck.mandatoryString("fname", fname);
        this.Params = new HashMap(17);
        this.Params.put("LanguageName", this.Lan.isoName);
        this.Params.put("Protection", this.Protection);
        this.Params.put("Paradigms", this.paradigms);
        this.Params.put("Alphabet", this.alphabet);
        this.Params.put("Alphabetlog", this.alphabetlog);
        this.Params.put("Infos", this.infos);
        this.Params.put("Infolog", this.infolog);
        this.Params.put("Infobitstable", this.infobitstable);
        this.Params.put("Buffer", this.buffer);
        this.Params.put("Bufferc", this.bufferc);
        this.Params.put("BufferL", this.bufferl);
        this.Params.put("BuffercL", this.buffercl);
        this.Params.put("Buflog", this.buflog);
        this.Params.put("version", Float.valueOf(2.0f));
        FileOutputStream fs = new FileOutputStream(fname);
        ObjectOutputStream serializer = new ObjectOutputStream(fs);
        try {
            serializer.writeObject(this);
            if (serializer != null) {
                serializer.close();
            }
        }
        catch (OutOfMemoryError E) {
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Compilation Stopped.. Insufficient Memory!!!", "NooJ", 0);
            etatsave = 0;
            serializer.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void saveComments(String fullname, int nbofinflectedforms, int dics_nbofstates, int dicc_nbofstates, int dicsl_nbofstates, int diccl_nbofstates) throws FileNotFoundException {
        ParameterCheck.mandatoryString("fullname", fullname);
        PrintWriter sw = null;
        try {
            sw = new PrintWriter(fullname);
            sw.println("NooJ v4.x Compiled Dictionary");
            sw.println("recognizes " + nbofinflectedforms + " word forms.");
            if (dics_nbofstates > dicsl_nbofstates) {
                sw.print(new Integer(dics_nbofstates).toString() + "/");
            } else {
                sw.print(new Integer(dicsl_nbofstates).toString() + "/");
            }
            if (dicc_nbofstates > diccl_nbofstates) {
                sw.print(dicc_nbofstates);
            } else {
                sw.print(diccl_nbofstates);
            }
            sw.println(" states, " + this.infos.length + " different analyses.");
            sw.println();
            if (this.Comments != null) {
                sw.print(this.Comments);
            }
        }
        finally {
            if (sw != null) {
                sw.close();
            }
        }
    }

    private void readTrans(UnsignedByte[] buf, int stateadr, int infolog, int alphabetlog, int buflog, int it, RefObject<Integer> charindex, RefObject<Integer> dest) {
        ParameterCheck.mandatory("buf", buf);
        ParameterCheck.mandatory("charindex", charindex);
        ParameterCheck.mandatory("dest", dest);
        charindex.argvalue = FSDic.readFromBuf(buf, stateadr + infolog + alphabetlog + it * (buflog + alphabetlog), alphabetlog);
        dest.argvalue = FSDic.readFromBuf(buf, stateadr + infolog + alphabetlog + it * (buflog + alphabetlog) + alphabetlog, buflog);
    }

    private void addNoDuplicate(RefObject<ArrayList<String>> results, String aresult) {
        ParameterCheck.mandatory("results", results);
        ParameterCheck.mandatory("aresult", aresult);
        if (results.argvalue == null) {
            results.argvalue = new ArrayList();
        }
        for (String res : (ArrayList)results.argvalue) {
            if (!aresult.equals(res)) continue;
            return;
        }
        ((ArrayList)results.argvalue).add(aresult);
    }

    private boolean alreadyThereInMultiwordResults(ArrayList<String> results, String aresult) {
        ParameterCheck.mandatory("results", results);
        ParameterCheck.mandatory("aresult", aresult);
        if (results == null) {
            results = new ArrayList();
        }
        for (int i = 0; i < results.size(); i += 2) {
            String res = results.get(i);
            if (!aresult.equals(res)) continue;
            return true;
        }
        return false;
    }

    public static boolean isSemiticVowel(char c) {
        switch (c) {
            case '\u05b0': 
            case '\u05b1': 
            case '\u05b2': 
            case '\u05b3': 
            case '\u05b4': 
            case '\u05b5': 
            case '\u05b6': 
            case '\u05b7': 
            case '\u05b8': 
            case '\u05b9': 
            case '\u05bb': 
            case '\u05bc': 
            case '\u05c1': 
            case '\u05c2': {
                return true;
            }
            case '\u064b': 
            case '\u064c': 
            case '\u064d': 
            case '\u064e': 
            case '\u064f': 
            case '\u0650': 
            case '\u0651': 
            case '\u0652': {
                return true;
            }
        }
        return false;
    }

    private ArrayList<String> lookUpCompound0(String text, int position, UnsignedByte[] bufferc, Engine engine) {
        ParameterCheck.mandatoryString("text", text);
        ParameterCheck.mandatory("bufferc", bufferc);
        ParameterCheck.mandatory("engine", engine);
        ArrayList<String> info = null;
        int stateadr = 0;
        int charindex = 0;
        int dest = 0;
        Stack<Trace> stack = new Stack<Trace>();
        stack.push(new Trace());
        while (stack.size() > 0) {
            Trace curtrc = (Trace)stack.pop();
            stateadr = curtrc.stateadr;
            int ipos = curtrc.txtpos;
            int infonb = FSDic.readFromBuf(bufferc, stateadr, this.infolog);
            if (infonb > this.infos.length) {
                System.out.println("**********");
                System.out.println("Corruption in compound .jnod file: I read infonb = " + infonb);
                System.out.println("In state " + stateadr + " infolog = " + this.infolog);
                System.out.println("but infos.Length = " + this.infos.length);
                return null;
            }
            if (stateadr > 0 && infonb > 0 && (position + ipos == text.length() || !Language.isLetter(text.charAt(position + ipos)) || this.Lan.asianTokenizer || ipos > 0 && !Language.isLetter(text.charAt(position + ipos - 1)))) {
                ArrayList<String> infs = this.unCompactInfo(this.infos[infonb]);
                if (info == null) {
                    info = new ArrayList<String>();
                }
                for (int i = 0; i < infs.size(); ++i) {
                    String diclemma = null;
                    String dicinfo = null;
                    String category = null;
                    String lexinfo = infs.get(i);
                    String[] features = null;
                    String trace = curtrc.trace;
                    if (lexinfo.charAt(0) == ',' && lexinfo.charAt(1) == '<') {
                        info.add(trace + "," + trace + lexinfo);
                        info.add(Integer.toString(ipos));
                        continue;
                    }
                    RefObject<Object> tempRef_diclemma = new RefObject<Object>(diclemma);
                    RefObject<Object> tempRef_dicinfo = new RefObject<Object>(dicinfo);
                    RefObject<Object> tempRef_category = new RefObject<Object>(category);
                    RefObject<Object> tempRef_features = new RefObject<Object>(features);
                    Dic.parseFactorizedInfo(lexinfo, tempRef_diclemma, tempRef_dicinfo, tempRef_category, tempRef_features);
                    diclemma = (String)tempRef_diclemma.argvalue;
                    dicinfo = (String)tempRef_dicinfo.argvalue;
                    category = (String)tempRef_category.argvalue;
                    features = (String[])tempRef_features.argvalue;
                    ArrayList<String> dicinfos = Dic.normalizeInformation(category, features, engine.properties);
                    if (dicinfos == null) {
                        if (diclemma != null) {
                            info.add(trace + "," + Dic.unCompressCompoundLemma(trace, diclemma) + "," + dicinfo);
                        } else {
                            info.add(trace + "," + dicinfo);
                        }
                        info.add(Integer.toString(ipos));
                        continue;
                    }
                    if (diclemma != null) {
                        for (String dicinfo0 : dicinfos) {
                            info.add(trace + "," + Dic.unCompressCompoundLemma(trace, diclemma) + "," + dicinfo0);
                            info.add(Integer.toString(ipos));
                        }
                        continue;
                    }
                    for (String dicinfo0 : dicinfos) {
                        info.add(trace + "," + dicinfo0);
                        info.add(Integer.toString(ipos));
                    }
                }
            }
            if (text == null || position + ipos > text.length()) continue;
            if (position + ipos < text.length() && text.charAt(position + ipos) == '\u0640') {
                Trace newtrc = new Trace();
                newtrc.stateadr = stateadr;
                newtrc.txtpos = ipos + 1;
                newtrc.trace = curtrc.trace;
                stack.push(newtrc);
                continue;
            }
            int transnb = FSDic.readFromBuf(bufferc, stateadr + this.infolog, this.alphabetlog);
            for (int it = 0; it < transnb; ++it) {
                RefObject<Integer> tempRef_charindex = new RefObject<Integer>(charindex);
                RefObject<Integer> tempRef_dest = new RefObject<Integer>(dest);
                this.readTrans(bufferc, stateadr, this.infolog, this.alphabetlog, this.buflogc, it, tempRef_charindex, tempRef_dest);
                charindex = (Integer)tempRef_charindex.argvalue;
                dest = (Integer)tempRef_dest.argvalue;
                if (charindex > this.alphabet.length) {
                    System.out.println("*********");
                    System.out.println("Corruption Problem in compound .jnod dictionary at state: " + stateadr);
                    System.out.println("infolog = " + this.infolog + ", alphabetlog = " + this.alphabetlog);
                    System.out.println("charindex = " + charindex + ", dest = " + dest);
                    System.out.println("Nb of transitions = " + transnb);
                    System.out.println("alphabet.Length = " + this.alphabet.length);
                    return null;
                }
                if (dest > bufferc.length) {
                    System.out.println("*********");
                    System.out.println("Corruption Problem in compound .jnod dictionary at state: " + stateadr);
                    System.out.println("infolog = " + this.infolog + ", alphabetlog = " + this.alphabetlog);
                    System.out.println("charindex = " + charindex + ", dest = " + dest);
                    System.out.println("Nb of transitions = " + transnb);
                    System.out.println("alphabet.Length = " + this.alphabet.length);
                    return null;
                }
                if (position + ipos < text.length()) {
                    if (this.alphabet[charindex] == ' ') {
                        boolean amatch = false;
                        while (position + ipos < text.length()) {
                            if (text.charAt(position + ipos) == '<') {
                                int i2 = 0;
                                while (position + ipos + i2 < text.length() && text.charAt(position + ipos + i2) != '>') {
                                    ++i2;
                                }
                                if (position + ipos + i2 == text.length()) break;
                                ipos += i2 + 1;
                                amatch = true;
                            }
                            if (!Character.isWhitespace(text.charAt(position + ipos))) break;
                            amatch = true;
                            while (position + ipos < text.length() && Character.isWhitespace(text.charAt(position + ipos))) {
                                ++ipos;
                            }
                        }
                        if (!amatch) continue;
                        Trace newtrc = new Trace();
                        newtrc.stateadr = dest;
                        newtrc.txtpos = ipos;
                        newtrc.trace = curtrc.trace + new Character(this.alphabet[charindex]).toString();
                        stack.push(newtrc);
                        continue;
                    }
                    if (text.charAt(position + ipos) == this.alphabet[charindex] || Character.isUpperCase(text.charAt(position + ipos)) && text.charAt(position + ipos) == Character.toUpperCase(this.alphabet[charindex]) || Character.isUpperCase(text.charAt(position + ipos)) && !this.Lan.isoName.equals("de") && text.charAt(position + ipos) == Language.toNoAccent(Character.toUpperCase(this.alphabet[charindex]))) {
                        Trace newtrc = new Trace();
                        newtrc.stateadr = dest;
                        newtrc.txtpos = ipos + 1;
                        newtrc.trace = curtrc.trace + new Character(this.alphabet[charindex]).toString();
                        stack.push(newtrc);
                        continue;
                    }
                    if (!FSDic.isSemiticVowel(this.alphabet[charindex])) continue;
                    Trace newtrc = new Trace();
                    newtrc.stateadr = dest;
                    newtrc.txtpos = ipos;
                    newtrc.trace = curtrc.trace + new Character(this.alphabet[charindex]).toString();
                    stack.push(newtrc);
                    continue;
                }
                if (!FSDic.isSemiticVowel(this.alphabet[charindex])) continue;
                Trace newtrc = new Trace();
                newtrc.stateadr = dest;
                newtrc.txtpos = ipos;
                newtrc.trace = curtrc.trace + new Character(this.alphabet[charindex]).toString();
                stack.push(newtrc);
            }
        }
        return info;
    }

    ArrayList<String> lookUpCompound(String text, int position, Engine engine) {
        ParameterCheck.mandatoryString("text", text);
        ParameterCheck.mandatory("engine", engine);
        ArrayList<String> res0 = this.lookUpCompound0(text, position, this.bufferc, engine);
        if (this.buffercl == null) {
            return res0;
        }
        if (res0 == null) {
            return null;
        }
        ArrayList res = new ArrayList();
        for (int ires0 = 0; ires0 < res0.size(); ires0 += 2) {
            Object r;
            boolean founddrv;
            String[] lexfeaturesdrv;
            String lexinfo;
            String lexcategory;
            String lexlemma;
            String lexentry;
            String lex;
            String[] myfeaturesdrv;
            String info;
            RefObject<Object> tempRef_info;
            String category;
            RefObject<Object> tempRef_category;
            String lemma;
            RefObject<Object> tempRef_lemma;
            String entry;
            RefObject<Object> tempRef_entry;
            String res0i = res0.get(ires0);
            boolean tempVar = !Dic.parseDELAF(res0i, tempRef_entry = new RefObject<Object>((entry = null)), tempRef_lemma = new RefObject<Object>((lemma = null)), null, tempRef_category = new RefObject<Object>((category = null)), tempRef_info = new RefObject<Object>((info = null)), null);
            entry = (String)tempRef_entry.argvalue;
            lemma = (String)tempRef_lemma.argvalue;
            category = (String)tempRef_category.argvalue;
            info = (String)tempRef_info.argvalue;
            if (tempVar) continue;
            String myfeatureflx = Dic.lookFor("FLX", info, null);
            if (myfeatureflx == null) {
                if (!this.alreadyThereInMultiwordResults(res, res0i)) {
                    res.add((String)res0i);
                    res.add((String)res0.get(ires0 + 1));
                }
            } else {
                String r2;
                String lexinfo2;
                String lexcategory2;
                String lexlemma2;
                String lexentry2;
                ArrayList<String> infolemma = this.lookUpCompound0(lemma, 0, this.buffercl, engine);
                if (infolemma != null) {
                    for (int jres = 0; jres < infolemma.size(); jres += 2) {
                        RefObject<Object> tempRef_lexinfo;
                        RefObject<Object> tempRef_lexcategory;
                        RefObject<Object> tempRef_lexlemma;
                        RefObject<Object> tempRef_lexentry;
                        String lex2 = infolemma.get(jres);
                        boolean tempVar2 = !Dic.parseDELAF(lex2, tempRef_lexentry = new RefObject<Object>((lexentry2 = null)), tempRef_lexlemma = new RefObject<Object>((lexlemma2 = null)), null, tempRef_lexcategory = new RefObject<Object>((lexcategory2 = null)), tempRef_lexinfo = new RefObject<Object>((lexinfo2 = null)), null);
                        lexentry2 = (String)tempRef_lexentry.argvalue;
                        lexlemma2 = (String)tempRef_lexlemma.argvalue;
                        lexcategory2 = (String)tempRef_lexcategory.argvalue;
                        lexinfo2 = (String)tempRef_lexinfo.argvalue;
                        if (tempVar2) continue;
                        String lexfeatureflx = Dic.lookFor("FLX", lexinfo2, null);
                        if (!category.equals(lexcategory2) || !myfeatureflx.equals(lexfeatureflx) || this.alreadyThereInMultiwordResults(res, r2 = res0i + Dic.removeFeature("FLX", lexinfo2))) continue;
                        res.add(r2);
                        res.add(res0.get(ires0 + 1));
                    }
                } else {
                    infolemma = this.lookUpSimple0(lemma, 0, this.bufferl, engine);
                    for (String lex3 : infolemma) {
                        RefObject<Object> tempRef_lexinfo2;
                        RefObject<Object> tempRef_lexcategory2;
                        RefObject<Object> tempRef_lexlemma2;
                        RefObject<Object> tempRef_lexentry2;
                        boolean tempVar3 = !Dic.parseDELAF(lex3, tempRef_lexentry2 = new RefObject<Object>((lexentry2 = null)), tempRef_lexlemma2 = new RefObject<Object>((lexlemma2 = null)), null, tempRef_lexcategory2 = new RefObject<Object>((lexcategory2 = null)), tempRef_lexinfo2 = new RefObject<Object>((lexinfo2 = null)), null);
                        lexentry2 = (String)tempRef_lexentry2.argvalue;
                        lexlemma2 = (String)tempRef_lexlemma2.argvalue;
                        lexcategory2 = (String)tempRef_lexcategory2.argvalue;
                        lexinfo2 = (String)tempRef_lexinfo2.argvalue;
                        if (tempVar3) continue;
                        String lexfeatureflx = Dic.lookFor("FLX", lexinfo2, null);
                        if (!category.equals(lexcategory2) || !myfeatureflx.equals(lexfeatureflx) || this.alreadyThereInMultiwordResults(res, r2 = res0i + Dic.removeFeature("FLX", lexinfo2))) continue;
                        res.add(r2);
                        res.add(res0.get(ires0 + 1));
                    }
                }
            }
            if ((myfeaturesdrv = Dic.lookForAll("DRV", info, null)) == null || myfeaturesdrv.length <= 0) continue;
            ArrayList<String> infolemma = this.lookUpSimple0(lemma, 0, this.bufferl, engine);
            if (infolemma != null) {
                for (int jres = 0; jres < infolemma.size(); ++jres) {
                    RefObject<Object> tempRef_lexinfo3;
                    RefObject<Object> tempRef_lexcategory3;
                    RefObject<Object> tempRef_lexlemma3;
                    RefObject<Object> tempRef_lexentry3;
                    lex = infolemma.get(jres);
                    boolean tempVar4 = !Dic.parseDELAF(lex, tempRef_lexentry3 = new RefObject<Object>((lexentry = null)), tempRef_lexlemma3 = new RefObject<Object>((lexlemma = null)), null, tempRef_lexcategory3 = new RefObject<Object>((lexcategory = null)), tempRef_lexinfo3 = new RefObject<Object>((lexinfo = null)), null);
                    lexentry = (String)tempRef_lexentry3.argvalue;
                    lexlemma = (String)tempRef_lexlemma3.argvalue;
                    lexcategory = (String)tempRef_lexcategory3.argvalue;
                    lexinfo = (String)tempRef_lexinfo3.argvalue;
                    if (tempVar4 || (lexfeaturesdrv = Dic.lookForAll("DRV", lexinfo, null)) == null) continue;
                    founddrv = false;
                    for (String lexfeaturedrv : lexfeaturesdrv) {
                        for (String mydrv : myfeaturesdrv) {
                            if (!lexfeaturedrv.equals(mydrv)) continue;
                            founddrv = true;
                            break;
                        }
                        if (founddrv) break;
                    }
                    if (!founddrv || this.alreadyThereInMultiwordResults(res, (String)(r = res0i + Dic.removeFeature("FLX", lexinfo)))) continue;
                    res.add(r);
                    res.add(res0.get(ires0 + 1));
                }
                continue;
            }
            infolemma = this.lookUpCompound0(lemma, 0, this.buffercl, engine);
            if (infolemma != null) {
                for (int jres = 0; jres < infolemma.size(); jres += 2) {
                    RefObject<Object> tempRef_lexinfo4;
                    RefObject<Object> tempRef_lexcategory4;
                    RefObject<Object> tempRef_lexlemma4;
                    RefObject<Object> tempRef_lexentry4;
                    lex = infolemma.get(jres);
                    boolean tempVar5 = !Dic.parseDELAF(lex, tempRef_lexentry4 = new RefObject<Object>((lexentry = null)), tempRef_lexlemma4 = new RefObject<Object>((lexlemma = null)), null, tempRef_lexcategory4 = new RefObject<Object>((lexcategory = null)), tempRef_lexinfo4 = new RefObject<Object>((lexinfo = null)), null);
                    lexentry = (String)tempRef_lexentry4.argvalue;
                    lexlemma = (String)tempRef_lexlemma4.argvalue;
                    lexcategory = (String)tempRef_lexcategory4.argvalue;
                    lexinfo = (String)tempRef_lexinfo4.argvalue;
                    if (tempVar5 || (lexfeaturesdrv = Dic.lookForAll("DRV", lexinfo, null)) == null) continue;
                    founddrv = false;
                    r = lexfeaturesdrv;
                    int n = ((String[])r).length;
                    for (int i = 0; i < n; ++i) {
                        String lexfeaturedrv;
                        lexfeaturedrv = r[i];
                        for (String mydrv : myfeaturesdrv) {
                            if (!lexfeaturedrv.equals(mydrv)) continue;
                            founddrv = true;
                            break;
                        }
                        if (founddrv) break;
                    }
                    if (!founddrv || this.alreadyThereInMultiwordResults(res, (String)(r = res0i + Dic.removeFeature("FLX", lexinfo)))) continue;
                    res.add(r);
                    res.add(res0.get(ires0 + 1));
                }
                continue;
            }
            RefObject<ArrayList<String>> tempRef_res = new RefObject<ArrayList<String>>(res);
            this.addNoDuplicate(tempRef_res, res0i);
            res = (ArrayList)tempRef_res.argvalue;
        }
        return res;
    }

    private ArrayList<String> lookUpSimple0(String text, int position, UnsignedByte[] buffer, Engine engine) {
        ParameterCheck.mandatoryString("text", text);
        ParameterCheck.mandatory("bufferc", this.bufferc);
        ParameterCheck.mandatory("engine", engine);
        ArrayList<String> info = null;
        int stateadr = 0;
        int charindex = 0;
        int dest = 0;
        Stack<Trace> stack = new Stack<Trace>();
        stack.push(new Trace());
        while (stack.size() > 0) {
            Trace curtrc = (Trace)stack.pop();
            stateadr = curtrc.stateadr;
            int ipos = curtrc.txtpos;
            int infonb = FSDic.readFromBuf(buffer, stateadr, this.infolog);
            if (!(infonb <= 0 || position + ipos != text.length() && Language.isLetter(text.charAt(position + ipos)))) {
                assert (infonb < this.infos.length);
                ArrayList<String> infs = this.unCompactInfo(this.infos[infonb]);
                if (info == null) {
                    info = new ArrayList<String>();
                }
                for (int i = 0; i < infs.size(); ++i) {
                    String diclemma = null;
                    String category = null;
                    String dicinfo = null;
                    String[] features = null;
                    String lexinfo = infs.get(i);
                    String trace = curtrc.trace;
                    if (lexinfo.charAt(0) == ',' && lexinfo.charAt(1) == '<') {
                        info.add(trace + "," + trace + lexinfo);
                        continue;
                    }
                    RefObject<Object> tempRef_diclemma = new RefObject<Object>(diclemma);
                    RefObject<Object> tempRef_dicinfo = new RefObject<Object>(dicinfo);
                    RefObject<Object> tempRef_category = new RefObject<Object>(category);
                    RefObject<Object> tempRef_features = new RefObject<Object>(features);
                    Dic.parseFactorizedInfo(lexinfo, tempRef_diclemma, tempRef_dicinfo, tempRef_category, tempRef_features);
                    diclemma = (String)tempRef_diclemma.argvalue;
                    dicinfo = (String)tempRef_dicinfo.argvalue;
                    category = (String)tempRef_category.argvalue;
                    features = (String[])tempRef_features.argvalue;
                    ArrayList<String> dicinfos = Dic.normalizeInformation(category, features, engine.properties);
                    if (dicinfos == null) {
                        if (Dictionary.AllLetters(trace) || this.Lan.asianTokenizer) {
                            info.add(trace + "," + Dic.unCompressCompoundLemma(trace, diclemma) + "," + dicinfo);
                            continue;
                        }
                        info.add(trace + "," + Dic.unCompressSimpleLemma(trace, diclemma) + "," + dicinfo);
                        continue;
                    }
                    if (diclemma != null) {
                        for (String dicinfo0 : dicinfos) {
                            if (Dictionary.AllLetters(trace) || this.Lan.asianTokenizer) {
                                info.add(trace + "," + Dic.unCompressCompoundLemma(trace, diclemma) + "," + dicinfo0);
                                continue;
                            }
                            info.add(trace + "," + Dic.unCompressSimpleLemma(trace, diclemma) + "," + dicinfo0);
                        }
                        continue;
                    }
                    for (String dicinfo0 : dicinfos) {
                        info.add(trace + "," + dicinfo0);
                    }
                }
            }
            if (text == null || position + ipos > text.length()) continue;
            if (position + ipos < text.length() && text.charAt(position + ipos) == '\u0640') {
                Trace newtrc = new Trace();
                newtrc.stateadr = stateadr;
                newtrc.txtpos = ipos + 1;
                newtrc.trace = curtrc.trace;
                stack.push(newtrc);
                continue;
            }
            int transnb = FSDic.readFromBuf(buffer, stateadr + this.infolog, this.alphabetlog);
            for (int it = 0; it < transnb; ++it) {
                Trace newtrc;
                RefObject<Integer> tempRef_charindex = new RefObject<Integer>(charindex);
                RefObject<Integer> tempRef_dest = new RefObject<Integer>(dest);
                this.readTrans(buffer, stateadr, this.infolog, this.alphabetlog, this.buflog, it, tempRef_charindex, tempRef_dest);
                charindex = (Integer)tempRef_charindex.argvalue;
                dest = (Integer)tempRef_dest.argvalue;
                if (position + ipos < text.length()) {
                    if (text.charAt(position + ipos) == this.alphabet[charindex] || Character.isUpperCase(text.charAt(position + ipos)) && text.charAt(position + ipos) == Character.toUpperCase(this.alphabet[charindex]) || Character.isUpperCase(text.charAt(position + ipos)) && !this.Lan.isoName.equals("de") && text.charAt(position + ipos) == Language.toNoAccent(Character.toUpperCase(this.alphabet[charindex]))) {
                        newtrc = new Trace();
                        newtrc.stateadr = dest;
                        newtrc.txtpos = ipos + 1;
                        newtrc.trace = curtrc.trace + new Character(this.alphabet[charindex]).toString();
                        stack.push(newtrc);
                        continue;
                    }
                    if (!FSDic.isSemiticVowel(this.alphabet[charindex])) continue;
                    newtrc = new Trace();
                    newtrc.stateadr = dest;
                    newtrc.txtpos = ipos;
                    newtrc.trace = curtrc.trace + new Character(this.alphabet[charindex]).toString();
                    stack.push(newtrc);
                    continue;
                }
                if (!FSDic.isSemiticVowel(this.alphabet[charindex])) continue;
                newtrc = new Trace();
                newtrc.stateadr = dest;
                newtrc.txtpos = ipos;
                newtrc.trace = curtrc.trace + new Character(this.alphabet[charindex]).toString();
                stack.push(newtrc);
            }
        }
        return info;
    }

    /*
     * WARNING - void declaration
     */
    ArrayList<String> lookUpSimple(String text, int position, Engine engine) {
        ParameterCheck.mandatoryString("text", text);
        ParameterCheck.mandatory("engine", engine);
        ArrayList<String> res0 = this.lookUpSimple0(text, position, this.buffer, engine);
        if (this.bufferl == null) {
            return res0;
        }
        if (res0 == null) {
            return null;
        }
        ArrayList res = new ArrayList();
        for (String res0i : res0) {
            void var20_25;
            boolean founddrv;
            String[] lexfeaturesdrv;
            String lexinfo;
            String lexcategory;
            String lexlemma;
            String lexentry;
            String[] myfeaturesdrv;
            String info;
            RefObject<Object> tempRef_info;
            String category;
            RefObject<Object> tempRef_category;
            String lemma;
            RefObject<Object> tempRef_lemma;
            String entry;
            RefObject<Object> tempRef_entry;
            boolean tempVar = !Dic.parseDELAF(res0i, tempRef_entry = new RefObject<Object>((entry = null)), tempRef_lemma = new RefObject<Object>((lemma = null)), null, tempRef_category = new RefObject<Object>((category = null)), tempRef_info = new RefObject<Object>((info = null)), null);
            entry = (String)tempRef_entry.argvalue;
            lemma = (String)tempRef_lemma.argvalue;
            category = (String)tempRef_category.argvalue;
            info = (String)tempRef_info.argvalue;
            if (tempVar) continue;
            String myfeatureflx = Dic.lookFor("FLX", info, null);
            if (myfeatureflx == null) {
                RefObject<ArrayList<String>> tempRef_res = new RefObject<ArrayList<String>>(res);
                this.addNoDuplicate(tempRef_res, res0i);
                res = (ArrayList)tempRef_res.argvalue;
            } else {
                String lexfeatureflx;
                ArrayList<String> infolemma = this.lookUpSimple0(lemma, 0, this.bufferl, engine);
                if (infolemma != null) {
                    for (String string : infolemma) {
                        String lexentry2 = null;
                        String lexlemma2 = null;
                        String lexcategory2 = null;
                        String lexinfo2 = null;
                        RefObject<Object> tempRef_lexentry = new RefObject<Object>(lexentry2);
                        RefObject<Object> tempRef_lexlemma = new RefObject<Object>(lexlemma2);
                        RefObject<Object> tempRef_lexcategory = new RefObject<Object>(lexcategory2);
                        RefObject<Object> tempRef_lexinfo = new RefObject<Object>(lexinfo2);
                        Dic.parseDELAF(string, tempRef_lexentry, tempRef_lexlemma, null, tempRef_lexcategory, tempRef_lexinfo, null);
                        lexentry2 = (String)tempRef_lexentry.argvalue;
                        lexlemma2 = (String)tempRef_lexlemma.argvalue;
                        lexcategory2 = (String)tempRef_lexcategory.argvalue;
                        lexinfo2 = (String)tempRef_lexinfo.argvalue;
                        if (!category.equals(lexcategory2) || !myfeatureflx.equals(lexfeatureflx = Dic.lookFor("FLX", lexinfo2, null))) continue;
                        RefObject<ArrayList<String>> tempRef_res2 = new RefObject<ArrayList<String>>(res);
                        this.addNoDuplicate(tempRef_res2, res0i + Dic.sortInfos(Dic.removeFeature("FLX", lexinfo2)));
                        res = (ArrayList)tempRef_res2.argvalue;
                    }
                } else {
                    infolemma = this.lookUpCompound0(lemma, 0, this.buffercl, engine);
                    if (infolemma != null) {
                        for (int ilex = 0; ilex < infolemma.size(); ilex += 2) {
                            String string = infolemma.get(ilex);
                            String lexentry2 = null;
                            String lexlemma2 = null;
                            String lexcategory2 = null;
                            String lexinfo2 = null;
                            RefObject<Object> tempRef_lexentry2 = new RefObject<Object>(lexentry2);
                            RefObject<Object> tempRef_lexlemma2 = new RefObject<Object>(lexlemma2);
                            RefObject<Object> tempRef_lexcategory2 = new RefObject<Object>(lexcategory2);
                            RefObject<Object> tempRef_lexinfo2 = new RefObject<Object>(lexinfo2);
                            Dic.parseDELAF(string, tempRef_lexentry2, tempRef_lexlemma2, null, tempRef_lexcategory2, tempRef_lexinfo2, null);
                            lexentry2 = (String)tempRef_lexentry2.argvalue;
                            lexlemma2 = (String)tempRef_lexlemma2.argvalue;
                            lexcategory2 = (String)tempRef_lexcategory2.argvalue;
                            lexinfo2 = (String)tempRef_lexinfo2.argvalue;
                            if (!category.equals(lexcategory2) || !myfeatureflx.equals(lexfeatureflx = Dic.lookFor("FLX", lexinfo2, null))) continue;
                            RefObject<ArrayList<String>> tempRef_res3 = new RefObject<ArrayList<String>>(res);
                            this.addNoDuplicate(tempRef_res3, res0i + Dic.sortInfos(Dic.removeFeature("FLX", lexinfo2)));
                            res = (ArrayList)tempRef_res3.argvalue;
                        }
                    } else {
                        RefObject<ArrayList<String>> tempRef_res4 = new RefObject<ArrayList<String>>(res);
                        this.addNoDuplicate(tempRef_res4, res0i);
                        res = (ArrayList)tempRef_res4.argvalue;
                    }
                }
            }
            if ((myfeaturesdrv = Dic.lookForAll("DRV", info, null)) == null || myfeaturesdrv.length <= 0) continue;
            ArrayList<String> infolemma = this.lookUpSimple0(lemma, 0, this.bufferl, engine);
            if (infolemma != null) {
                for (String lex : infolemma) {
                    lexentry = null;
                    lexlemma = null;
                    lexcategory = null;
                    lexinfo = null;
                    RefObject<Object> tempRef_lexentry3 = new RefObject<Object>(lexentry);
                    RefObject<Object> tempRef_lexlemma3 = new RefObject<Object>(lexlemma);
                    RefObject<Object> tempRef_lexcategory3 = new RefObject<Object>(lexcategory);
                    RefObject<Object> tempRef_lexinfo3 = new RefObject<Object>(lexinfo);
                    Dic.parseDELAF(lex, tempRef_lexentry3, tempRef_lexlemma3, null, tempRef_lexcategory3, tempRef_lexinfo3, null);
                    lexentry = (String)tempRef_lexentry3.argvalue;
                    lexlemma = (String)tempRef_lexlemma3.argvalue;
                    lexcategory = (String)tempRef_lexcategory3.argvalue;
                    lexinfo = (String)tempRef_lexinfo3.argvalue;
                    lexfeaturesdrv = Dic.lookForAll("DRV", lexinfo, null);
                    if (lexfeaturesdrv == null) continue;
                    founddrv = false;
                    for (String lexfeaturedrv : lexfeaturesdrv) {
                        if (!myfeaturesdrv[0].equals(lexfeaturedrv)) continue;
                        founddrv = true;
                        break;
                    }
                    if (!founddrv) continue;
                    RefObject<ArrayList<String>> refObject = new RefObject<ArrayList<String>>(res);
                    this.addNoDuplicate(refObject, res0i + Dic.sortInfos(Dic.removeFeature("FLX", lexinfo)));
                    res = (ArrayList)refObject.argvalue;
                }
                continue;
            }
            infolemma = this.lookUpCompound0(lemma, 0, this.buffercl, engine);
            if (infolemma == null) continue;
            boolean bl = false;
            while (var20_25 < infolemma.size()) {
                String lex;
                lex = infolemma.get((int)var20_25);
                lexentry = null;
                lexlemma = null;
                lexcategory = null;
                lexinfo = null;
                RefObject<Object> tempRef_lexentry4 = new RefObject<Object>(lexentry);
                RefObject<Object> tempRef_lexlemma4 = new RefObject<Object>(lexlemma);
                RefObject<Object> tempRef_lexcategory4 = new RefObject<Object>(lexcategory);
                RefObject<Object> tempRef_lexinfo4 = new RefObject<Object>(lexinfo);
                Dic.parseDELAF(lex, tempRef_lexentry4, tempRef_lexlemma4, null, tempRef_lexcategory4, tempRef_lexinfo4, null);
                lexentry = (String)tempRef_lexentry4.argvalue;
                lexlemma = (String)tempRef_lexlemma4.argvalue;
                lexcategory = (String)tempRef_lexcategory4.argvalue;
                lexinfo = (String)tempRef_lexinfo4.argvalue;
                lexfeaturesdrv = Dic.lookForAll("DRV", lexinfo, null);
                if (lexfeaturesdrv != null) {
                    founddrv = false;
                    for (String lexfeaturedrv : lexfeaturesdrv) {
                        if (!myfeaturesdrv[0].equals(lexfeaturedrv)) continue;
                        founddrv = true;
                        break;
                    }
                    if (founddrv) {
                        RefObject<ArrayList<String>> refObject = new RefObject<ArrayList<String>>(res);
                        this.addNoDuplicate(refObject, res0i + Dic.sortInfos(Dic.removeFeature("FLX", lexinfo)));
                        res = (ArrayList)refObject.argvalue;
                    }
                }
                var20_25 += 2;
            }
        }
        return res;
    }

    public class Trace {
        private int txtpos = 0;
        private int stateadr = 0;
        private String trace = "";

        private Trace() {
        }
    }
}

